// Das Programm demonstriert die Verwendung der Klassen FileInputStream und FileOutputStream.
// Zum Erstellen einer Dateikopie in Java 7 sollte man jedoch eine copy() - Methode der Klasse Files verwenden.

import java.io.*;
import java.nio.file.Files;
import java.nio.file.Path;

class FileCopy {
	final static String QUELLE = "quelle.dat", ZIEL = "ziel.dat";
	final static int BUFLEN = 1048576; // Ein MB (1024*1024 Bytes) als Puffergröße

	public static void main(String[] args) throws IOException {
		byte[] buffer = new byte[BUFLEN];
		int nread;
		long zeit, total = 0;
		try (var fis = new FileInputStream(QUELLE);
			 var fos = new FileOutputStream(ZIEL)) {
//			try (var fis = Files.newInputStream(Path.of(QUELLE));
//				 var fos = Files.newOutputStream(Path.of(ZIEL))) {
//			System.out.println("class fos = " + fos.getClass());
//		try (var  fis = new BufferedInputStream(Files.newInputStream(Path.of(QUELLE)));
//			 var  fos = new BufferedOutputStream(Files.newOutputStream(Path.of(ZIEL)))) {
			zeit = System.currentTimeMillis();
			System.out.println("Kopieren von " + QUELLE + " in " + ZIEL + " gestartet");
			for(int i = 1; ; i++) {
				nread = fis.read(buffer, 0, Math.min(BUFLEN, fis.available()));
				if (nread == 0)
					break;
				else {
					fos.write(buffer, 0, nread);
					total += nread;
					if (total >= BUFLEN) {
						String s = i + " Megabyte";
						for (int j = 0; j < s.length(); j++)
							System.out.print("\b");
						System.out.print(s);
					}
				}
			}
			zeit = System.currentTimeMillis() - zeit;
			System.out.println("\nEs wurden " + total + " Bytes kopiert. "+
				               "(Benötigte Zeit: " + zeit + " Millisekunden.)");
		}
	}
}